/*
 * Decompiled with CFR 0.152.
 */
package org.figuramc.figura.utils;

import dev.architectury.injectables.annotations.ExpectPlatform;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.nio.file.Path;
import org.figuramc.figura.utils.neoforge.PlatformUtilsImpl;

public class PlatformUtils {
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static Path getGameDir() {
        return PlatformUtilsImpl.getGameDir();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static String getFiguraModVersionString() {
        return PlatformUtilsImpl.getFiguraModVersionString();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static Path getConfigDir() {
        return PlatformUtilsImpl.getConfigDir();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean isModLoaded(String modId) {
        return PlatformUtilsImpl.isModLoaded(modId);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static String getModVersion(String modId) {
        return PlatformUtilsImpl.getModVersion(modId);
    }

    public static int compareVersionTo(String v1, String v2) {
        if (v1 == null) {
            return 1;
        }
        String[] v1Parts = v1.split("[+,_]")[0].split("\\.");
        String[] v2Parts = v2.split("[+,_]")[0].split("\\.");
        int length = Math.max(v1Parts.length, v2Parts.length);
        for (int i = 0; i < length; ++i) {
            int v2Part;
            int v1Part = i < v1Parts.length ? Integer.parseInt(v1Parts[i]) : 0;
            int n = v2Part = i < v2Parts.length ? Integer.parseInt(v2Parts[i]) : 0;
            if (v1Part < v2Part) {
                return -1;
            }
            if (v1Part <= v2Part) continue;
            return 1;
        }
        return 0;
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static ModLoader getModLoader() {
        return PlatformUtilsImpl.getModLoader();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static InputStream loadFileFromRoot(String file) throws FileNotFoundException {
        return PlatformUtilsImpl.loadFileFromRoot((String)file);
    }

    public static enum ModLoader {
        FORGE,
        FABRIC;

    }
}

